<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHistoricoAdquisicionVehiculosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('historico_adquisicion_vehiculos', function (Blueprint $table) {
            $table->id('pk_h_adquisicion_vehiculos');
            $table->unsignedBigInteger('fk_acq_vehicle');
            $table->unsignedBigInteger('fk_vehicle');
            $table->unsignedBigInteger('fk_user');
            $table->float('monto_adquisicion');
            $table->timestamp('fecha_adquisicion');
            $table->string('observaciones_adquisicion');
            $table->timestamp('fecha_transaccion');
            $table->foreign('fk_acq_vehicle')->references('pk_acq_vehicle')->on('tms_am_acquisition_vehicles');
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('historico_adquisicion_vehiculos');
    }
}
