<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class DataSigoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $zones = fopen(base_path() . '/database/csv/tms_am_zones.csv', 'r');

        while (($line = fgetcsv($zones, 1000, ',')) !== FALSE) {
            DB::table('tms_am_zones')->insert([
                'pk_zone' => $line[0],
                'name' => $line[1]
            ]);
        }
        fclose($zones);


        $vusages = fopen(base_path() . '/database/csv/tms_am_vehicle_usages.csv', 'r');
        while (($line = fgetcsv($vusages, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_usages')->insert([
                'pk_vehicle_usage' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vusages);

        $vtypes = fopen(base_path() . '/database/csv/tms_am_vehicle_types.csv', 'r');
        while (($line = fgetcsv($vtypes, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_types')->insert([
                'pk_vehicle_type' => $line[0],
                'name' => $line[1],
                'status' => true
            ]);
        }
        fclose($vtypes);

        $vorigins = fopen(base_path() . '/database/csv/tms_am_vehicle_origins.csv', 'r');
        while (($line = fgetcsv($vorigins, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_origins')->insert([
                'pk_vehicle_origin' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vorigins);

        $vfleets = fopen(base_path() . '/database/csv/tms_am_vehicle_fleets.csv', 'r');
        while (($line = fgetcsv($vfleets, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_fleets')->insert([
                'pk_vehicle_fleet' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vfleets);

        $vsuspensiontypes = fopen(base_path() . '/database/csv/tms_am_suspension_types.csv', 'r');
        while (($line = fgetcsv($vsuspensiontypes, 1000, ',')) !== FALSE) {
            DB::table('tms_am_suspension_types')->insert([
                'pk_suspension_type' => $line[0],
                'description' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vsuspensiontypes);

        $vstatus = fopen(base_path() . '/database/csv/tms_am_vehicle_status.csv', 'r');
        while (($line = fgetcsv($vstatus, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_status')->insert([
                'pk_vehicle_status' => $line[0],
                'name' => $line[1],
                'status' => true
            ]);
        }
        fclose($vstatus);

        $vstatusgroup = fopen(base_path() . '/database/csv/tms_am_status_groups.csv', 'r');
        while (($line = fgetcsv($vstatusgroup, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_status_groups')->insert([
                'pk_vehicle_status_group' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vstatusgroup);

        $vseattypes = fopen(base_path() . '/database/csv/tms_am_seat_types.csv', 'r');
        while (($line = fgetcsv($vseattypes, 1000, ',')) !== FALSE) {
            DB::table('tms_am_seat_types')->insert([
                'pk_seat_type' => $line[0],
                'description' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vseattypes);

        $vmanufacturers = fopen(base_path() . '/database/csv/tms_am_manufacturers.csv', 'r');
        while (($line = fgetcsv($vmanufacturers, 1000, ',')) !== FALSE) {
            DB::table('tms_am_manufacturers')->insert([
                'pk_manufacturer' => $line[0],
                'name' => $line[1],
                'status' => true
            ]);
        }
        fclose($vmanufacturers);

        $vgpsproviders = fopen(base_path() . '/database/csv/tms_am_gps_providers.csv', 'r');
        while (($line = fgetcsv($vgpsproviders, 1000, ',')) !== FALSE) {
            DB::table('tms_am_gps_providers')->insert([
                'pk_gps_provider' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vgpsproviders);

        $vfuels = fopen(base_path() . '/database/csv/tms_am_fuels.csv', 'r');
        while (($line = fgetcsv($vfuels, 1000, ',')) !== FALSE) {
            DB::table('tms_am_fuels')->insert([
                'pk_fuel' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($vfuels);

        $vfederalentities = fopen(base_path() . '/database/csv/tms_am_federal_entities.csv', 'r');
        while (($line = fgetcsv($vfederalentities, 1000, ',')) !== FALSE) {
            DB::table('tms_am_federal_entities')->insert([
                'pk_federal_entity' => $line[0],
                'name' => $line[1],
                'codename' => $line[2]
            ]);
        }
        fclose($vfederalentities);

        $ventitytypes = fopen(base_path() . '/database/csv/tms_am_entity_types.csv', 'r');
        while (($line = fgetcsv($ventitytypes, 1000, ',')) !== FALSE) {
            DB::table('tms_am_entity_types')->insert([
                'pk_entity_type' => $line[0],
                'name' => $line[1]
            ]);
        }
        fclose($ventitytypes);

        $ventitystatus = fopen(base_path() . '/database/csv/tms_am_entity_status.csv', 'r');
        while (($line = fgetcsv($ventitystatus, 1000, ',')) !== FALSE) {
            DB::table('tms_am_entity_status')->insert([
                'pk_entity_status' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($ventitystatus);

        $entities = fopen(base_path() . '/database/csv/tms_am_entities_legacy.csv', 'r');
        while (($line = fgetcsv($entities, 1000, ',')) !== FALSE) {
            DB::table('tms_am_entities')->insert([
                'pk_entity' => $line[0],
                'name' => $line[1],
                'fk_entity_status' => ($line[2] == "") ? null: $line[2],
                'codename' => ($line[3] == "") ? null: $line[3],
                'fk_zone' =>($line[4] == "") ? null: $line[4],
                'status' => true
            ]);
        }
        fclose($entities);

        
        $entityrel = fopen(base_path() . '/database/csv/tms_am_entity_relationships.csv', 'r');
        while (($line = fgetcsv($entityrel, 1000, ',')) !== FALSE) {
            DB::table('tms_am_entity_relationships')->insert([
                'fk_entity_type' => $line[0],
                'fk_entity' => $line[1]
            ]);
        }
        fclose($entityrel);

        $contactservices = fopen(base_path() . '/database/csv/tms_am_contact_services.csv', 'r');
        while (($line = fgetcsv($contactservices, 1000, ',')) !== FALSE) {
            DB::table('tms_am_contact_services')->insert([
                'pk_contact_service' => $line[0],
                'name' => $line[1],
                'alias' => $line[2],
                'phone_number' => $line[3],
                'email' => $line[4],
                'status' => $line[5]
            ]);
        }
        fclose($contactservices);

        $complementtypes = fopen(base_path() . '/database/csv/tms_am_complement_types.csv', 'r');
        while (($line = fgetcsv($complementtypes, 1000, ',')) !== FALSE) {
            DB::table('tms_am_complement_types')->insert([
                'pk_complement_type' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($complementtypes);

        $vcomplements = fopen(base_path() . '/database/csv/tms_am_vehicle_complements.csv', 'r');
        while (($line = fgetcsv($vcomplements, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_complements')->insert([
                'pk_vehicle_complement' => $line[0],
                'name' => $line[1],
                'fk_complement_type' => $line[2],
                'status' => $line[3]
            ]);
        }
        fclose($vcomplements);

        $colors = fopen(base_path() . '/database/csv/tms_am_colors.csv', 'r');
        while (($line = fgetcsv($colors, 1000, ',')) !== FALSE) {
            DB::table('tms_am_colors')->insert([
                'pk_color' => $line[0],
                'name' => $line[1],
                'status' => $line[2]
            ]);
        }
        fclose($colors);

        $insurances = fopen(base_path() . '/database/csv/tms_am_insurances.csv', 'r');
        while (($line = fgetcsv($insurances, 1000, ',')) !== FALSE) {
            DB::table('tms_am_insurances')->insert([
                'pk_insurance' => $line[0],
                'name' => $line[1],
                'date_register' => $line[2],
                'fk_contact_service' => $line[3],
                'status' => $line[4]
            ]);
        }
        fclose($insurances);


        /**********************DATA JSONS */
        DB::table('tms_am_parkinglots')->delete();
        DB::table('tms_am_locations')->delete();
        $json = File::get(base_path() . '/database/json/parkinglots.json');
        $data = json_decode($json);
        foreach ($data as $item){
        DB::table('tms_am_locations')->insert([
                'name' => $item->nombre_localizacion,
                'street' => $item->calle,
                'number' => $item->numero,
                'headquarters' => false,
                'cp' => $item->zipcode,
                'state' => $item->estado,
                'country' => $item->pais,
                'latitude' => $item->latitud,
                'longitude' => $item->longitud,
            ]);

        $location = DB::table('tms_am_locations')->orderBy('pk_location', 'desc')->first();

        DB::table('tms_am_parkinglots')->insert([
            'codename' => $item->nombre_estacionamiento,
            'rental' => 1,
            'fk_entity_company' => $item->unidad_negocio,
            'fk_location' => $location->pk_location,
            'fk_unit_rental' => null,
            'status' => true,
        ]);

        $parkinglot = DB::table('tms_am_parkinglots')->orderBy('pk_parkinglot', 'desc')->first();

        DB::table('tms_am_entity_parkinglot')->insert([
            'fk_entity_company' => $item->unidad_negocio,
            'fk_parkinglot' => $parkinglot->pk_parkinglot,
        ]);
        }
    }
}
