<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('menus')->delete();
        $json = File::get(base_path() . '/database/json/menu.json');
        $data = json_decode($json);
        foreach ($data as $item){
            DB::table('menus')->insert([
                'id_menu' => $item->id_menu,
                'id_padre' => $item->id_padre,
                'titulo' => $item->titulo,
                'url' => $item->url,
                'icono' => $item->icono,
                'class' => $item->class,
                'orden' => $item->orden,
                'fecha_registro' => $item->fecha_registro,
                'fecha_actualizacion' => $item->fecha_actualizacion,
                'fecha_baja' => $item->fecha_baja,
                'activo' => $item->activo,
            ]);

                DB::table('roles_has_menus')->insert([
                    'id_menu' => $item->pivot->id_menu,
                    'id_role' => $item->pivot->id_rol,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]);
        }

    }
}
