<?php

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Exceptions\RoleDoesNotExist;
use App\Models\Usuarios;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $admin = factory(Usuarios::class)->create([
            'username' => 'd.pacanins',
            'email' => 'd.pacanins@lidcorp.mx',
            'name' => 'David',
            'lastname' => 'Pacanins',
            'password' => '$2a$12$R9hOvbjSBONl9guSrAEvG.GGf/LqWVsue/Lpt2nteEVGFgW0e36Qm'
        ]);
        $gerente = factory(Usuarios::class)->create([
            'username' => 't.lidcorp',
            'name' => 'Test',
            'lastname' => 'Lidcorp'
        ]);
        $nomina1 = factory(Usuarios::class)->create([
            'username' => 'nomina1',
            'email' => 'dev_redrabbit_01@lidcorp.ad',
            'name' => 'Nomina1',
            'lastname' => 'Usuario',
            'password' => '$2y$10$ot2aALBD/XiyKDjOpm54Feues3kdvevLAIEDfgtmRJ8ycam6zWgzm'
        ]);
        $nomina2 = factory(Usuarios::class)->create([
            'username' => 'nomina2',
            'email' => 'dev_redrabbit_02@lidcorp.ad',
            'name' => 'Nomina2',
            'lastname' => 'Usuario',
            'password' => '$2y$10$ot2aALBD/XiyKDjOpm54Feues3kdvevLAIEDfgtmRJ8ycam6zWgzm'
        ]);

        try {
            $roleAdmin = Role::findByName('Administrador');
        } catch (RoleDoesNotExist $e) {
            $roleAdmin = Role::create(['name' => 'Administrador']);
        }
        $admin->assignRole($roleAdmin->name);

        try {
            $roleGerente = Role::findByName('Gerente');
        } catch (Exception $e) {
            $roleGerente = Role::create(['name' => 'Gerente']);
        }
        $gerente->assignRole($roleGerente->name);

        try {
            $roleNomina = Role::findByName('Nomina');
        } catch (Exception $e) {
            $roleNomina = Role::create(['name' => 'Nomina']);
        }
        $nomina1->assignRole($roleNomina->name);
        $nomina2->assignRole($roleNomina->name);
    }
}
