<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class VehicleFuelCapacitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $models = fopen(base_path() . '/database/csv/tanques_comb.csv', 'r');
        while (($line = fgetcsv($models, 1000, ',')) !== FALSE) {
            if( DB::table('tms_am_vehicles')->where('pk_vehicle', $line[0] )->exists()){
                DB::table('tms_am_vehicles')->where('pk_vehicle', $line[0] )->update([
                    'capacity_tank_current' => $line[1],
                    'last_updated_capacity_tank_current' => Carbon::now()
                ]);
            }
        }
    }
}
