<?php

use App\Models\Estacionamientos;
use App\Models\VehiculoGeneral;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\File;

class VehicleHistorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('historico_update_vehiculos')->delete();
        $models = fopen(base_path() . '/database/csv/tms_am_vehicle_history.csv', 'r');
        while (($line = fgetcsv($models, 1000, ',')) !== FALSE) {
            if(VehiculoGeneral::where('pk_vehicle', $line[1])->exists()){
                //Log::info("Cargar registro");
                DB::table('historico_update_vehiculos')->insert([
                    'pk_h_update_vehiculos' => $line[0],
                    'fk_vehicle' =>$line[1],
                    'eco' => $line[2],
                    'fk_vehicle_catalog' => $line[3],
                    'fk_color' => $line[4],
                    'plates' => ($line[5] == "" || $line[5] == null) ? "": $line[5],
                    'federal_plates' => ($line[6] == "" || $line[6] == null) ? "": $line[6],
                    'fuel_consumption' => ($line[7] == null || $line[7] == "") ? "": $line[7],
                    'engine_number' => ($line[8] == null || $line[8] == "") ? "": $line[8],
                    'serial_number' => ($line[9] == null || $line[9] == "") ? "": $line[9],
                    'fk_parkinglot' => $this->parkingsFinder($line[13]),
                    'fk_vehicle_status' => $line[16],
                    'fk_entity_company' => $line[17],
                    'fk_federal_entity' => ($line[18] == "" || $line[18] == null) ? 1: $line[18],
                    'passengers' => ($line[19] == null || $line[19] == "") ? "": $line[19],
                    'doors' =>  ($line[21] == null || $line[21] == "") ? 0: $line[21],
                    'fk_seat_type' => ($line[20] == null || $line[20] == "") ? 1: $line[20],
                    'fk_suspension_type' => ($line[22] == null || $line[22] == "") ? 1: $line[22],
                    'description' => ($line[24]== null || $line[24] == "") ? 1: $line[24],
                    'authorized_fuel_consumption' => ($line[25]== null || $line[25] == "") ? 0: $line[25],
                    'fk_vehicle_usage' => $line[26],
                    /* 'fk_vehicle_status_group' => $line[0],
                    'fk_vehicle_origin' => $line[0],
                    'fk_vehicle_fleet' => $line[0], */
                    'fk_fuel' => 1,
                    'fk_user' => $line[38],
                    'date_changed' => $line[39] /* $this->dateInToDate($item->historic_date, "days") */,
                    'time_changed' => $line[40] /* $this->dateInToDate($item->historic_time, "hours") */
                ]);
            }
        }
        fclose($models);
    }

    public function dateInToDate($date, $type){
        $convertdate = null;
        if($type == "hours"){
            Log::info("Cambiar hora int");
            if(strlen($date) == 5){
                $h = date_create("0".$date);
            }else{
                $h = date_create($date);
            }
            $convertdate = date_format($h, 'H:i:s');
        }else{
            Log::info("Cambiar fecha int");
            $d = date_create($date);
            $convertdate = date_format($d, 'Y-m-d');
        }
        return $convertdate;
    }

    public function parkingsFinder($data){
        $resp = null;
        if($data == "" || $data == null){
            $resp = null;
        }else{
            if(Estacionamientos::where('pk_parkinglot', $data)->exists()){
                $resp = $data;
            }
        }

        return $resp;
    }
}
