<?php

use App\Models\Docs;
use App\Models\Estacionamientos;
use App\Models\VehiculoGeneral;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class VehiculoSeeder extends Seeder
{

    var $timestampUnique = 0;
    var $meses = [];
    public function __construct()
    {
        //Los registros tengan la misma fecha y hora exacta
        $this->timestampUnique = Carbon::now('GMT-6');
        $this->meses    = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
    }
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $models = fopen(base_path() . '/database/csv/tms_am_vehicle_models_all.csv', 'r');
        while (($line = fgetcsv($models, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_models')->insert([
                'pk_vehicle_model' => $line[0],
                'name' => $line[1],
                'year' => "2012",
                'fk_manufacturer' => "1",
                'status' => true
            ]);
        }
        fclose($models);

        $catalogs = fopen(base_path() . '/database/csv/tms_am_vehicle_catalogs_all.csv', 'r');
        while (($line = fgetcsv($catalogs, 1000, ',')) !== FALSE) {
            DB::table('tms_am_vehicle_catalogs')->insert([
                'pk_vehicle_catalog' => $line[0],
                'fk_vehicle_type' => $line[1],
                'version' => $line[3],
                'fuel_consumption_avg' => $line[6],
                'fuel_capacity' => $line[7],
                'tax' => $line[8],
                'environment_tax' => $line[9],
                'fk_vehicle_model' => $line[14],
                'status' => true
            ]);
        }
        fclose($catalogs);
        
        //Log::info($dir);
        // Abre un directorio conocido, y procede a leer el contenido
        /*
        if (is_dir($dir)) {
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    //Log::info("nombre archivo: $file : tipo archivo: " . filetype($dir . $file));
                    if ($doc = opendir($dir."/".$file)) {
                        while (($files = readdir($doc)) !== false) {
                            Log::info("nombre archivo: ".$files);
                        }
                        closedir($doc);
                    }
                }
                closedir($dh);
            }
        }else{
            Log::info('No existe la ruta');
        }
        */
        /*
        $zip = new ZipArchive;
        if ($zip->open(base_path() . '/storage/files/carpeta_digital.zip') !== TRUE) {
            Log::info('Fallo al ejecutarse');
        }else{
            for( $i = 0; $i < $zip->numFiles; $i++ ){
                $stat = $zip->statIndex( $i );
                $lista = explode("/", $stat['name']);
                $folder = str_replace("  ", " ",$lista[1]);
                $folder = explode(" ",$folder);
                $ide = explode(".",$folder[0]); 
                Log::info($ide[1]);
            }
        }
        */
        DB::table('tms_am_vehicles')->delete();
        $json = File::get(base_path() . '/database/json/vehicles.legacy.json');
        $data = json_decode($json);
        foreach ($data->vehicles as $item){
            $vehiculo = new VehiculoGeneral();
            $vehiculo->pk_vehicle = $item->pk_vehicle;
            $vehiculo->eco = $item->eco;
            $vehiculo->fk_vehicle_catalog = $item->fk_vehicle_catalog;
            $vehiculo->fk_color = $item->fk_color;
            if($item->plates == null || $item->plates == ""){
                $vehiculo->plates = "";
            }else{
                $vehiculo->plates = $item->plates;
            }
            if($item->federal_plates == null || $item->federal_plates == ""){
                $vehiculo->federal_plates = "";
            }else{
                $vehiculo->federal_plates = $item->federal_plates;
            }
            if($item->fuel_consumption == null || $item->fuel_consumption == ""){
                $vehiculo->fuel_consumption = "";
            }else{
                $vehiculo->fuel_consumption = $item->fuel_consumption;
            }
            if($item->engine_number == null || $item->engine_number == ""){
                $vehiculo->engine_number = "";
            }else{
                $vehiculo->engine_number = $item->engine_number;
            }
            if($item->serial_number == null || $item->serial_number == ""){
                $vehiculo->serial_number = "";
            }else{
                $vehiculo->serial_number = $item->serial_number;
            }
            if(Estacionamientos::where('pk_parkinglot', $item->fk_parkinglot)->exists()){
                $vehiculo->fk_parkinglot = $item->fk_parkinglot;
            }else{
                $vehiculo->fk_parkinglot = null;
            }
            $vehiculo->fk_vehicle_status = $item->fk_vehicle_status;
            $vehiculo->fk_entity_company = $item->fk_entity_company;
            if($item->fk_federal_entity == null || $item->fk_federal_entity == ""){
                $vehiculo->fk_federal_entity = 1;
            }else{
                $vehiculo->fk_federal_entity = $item->fk_federal_entity;
            }
            if($item->passengers == null || $item->passengers == ""){
                $vehiculo->passengers = "";
            }else{
                $vehiculo->passengers = $item->passengers;
            }
            if($item->doors == null || $item->doors == ""){
                $vehiculo->doors = 0;
            }else{
                $vehiculo->doors = $item->doors;
            }
            if($item->fk_seat_type == null || $item->fk_seat_type == ""){
                $vehiculo->fk_seat_type = 1;
            }else{
                $vehiculo->fk_seat_type = $item->fk_seat_type;
            }
            if($item->fk_suspension_type == null || $item->fk_suspension_type == ""){
                $vehiculo->fk_suspension_type = 1;
            }else{
                $vehiculo->fk_suspension_type = $item->fk_suspension_type;
            }
            if($item->description == null || $item->description == ""){
                $vehiculo->description = "";
            }else{
                $vehiculo->description = $item->description;
            }
            if($item->authorized_fuel_consumption == null || $item->authorized_fuel_consumption == ""){
                $vehiculo->authorized_fuel_consumption = "";
            }else{
                $vehiculo->authorized_fuel_consumption = $item->authorized_fuel_consumption;
            }
            $vehiculo->fk_vehicle_usage = $item->fk_vehicle_usage;
            $vehiculo->fk_vehicle_status_group = $item->fk_vehicle_status_group;
            if($item->fk_vehicle_origin == null || $item->fk_vehicle_origin == ""){
                $vehiculo->fk_vehicle_origin = 1;
            }else{
                $vehiculo->fk_vehicle_origin = $item->fk_vehicle_origin;
            }
            if($item->fk_vehicle_fleet == null || $item->fk_vehicle_fleet == ""){
                $vehiculo->fk_vehicle_fleet = 1;
            }else{
                $vehiculo->fk_vehicle_fleet = $item->fk_vehicle_fleet;
            }
            //$vehiculo->fk_fuel = $item->fk_fuel;
            $vehiculo->fk_fuel = 1;
            $vehiculo->save();
            //ALTA EN TABLA VEHICULO
        }

        //Leer directorios con archivos
        $dir1 = base_path() ."\..\..\..\Users\Andres Herrrera\OneDrive - Transportes Lipu S.A. de C.V\Documentos\DocumentosSIGO\CPS-01";
        Log::channel('vehiculosfiles')->info($dir1);
        $this->getPathsArchivos($dir1, 0);
        Log::info("-----------------------------------------------------------------");
        $dir2 = base_path() ."\..\..\..\Users\Andres Herrrera\OneDrive - Transportes Lipu S.A. de C.V\Documentos\DocumentosSIGO\CPS-02";
        Log::channel('vehiculosfiles')->info($dir2);
        $this->getPathsArchivos($dir2, 0);
    }

    public function getPathsArchivos($path, $ide, array $archivos = array()) {
        $dir = opendir($path);
        if (!is_array($archivos)) {
            //en la primera ejecución se inicializa el array
            $archivos = array();
        }
        while ($current = readdir($dir)) {
            if ($current != "." && $current != "..") {

                if (is_dir($path . DIRECTORY_SEPARATOR . $current) && $ide == 0) {
                    
                    //descompone la cadena para tener el id
                    $folder = str_replace("  ", " ",$current);
                    $folder = explode(" ",$folder);
                    $id = explode(".",$folder[0]); 

                    //verifica si existe el vehiculo, si no, no entra al folder
                    if(VehiculoGeneral::where('pk_vehicle', $id[1])->exists()){
                        Log::channel('vehiculosfiles')->info("Si existe el vehiculo con id: ".$id[1]);
                        //Log::info($path."/".$current);
                        $archivos = self::getPathsArchivos($path. DIRECTORY_SEPARATOR .$current, $id[1]);
                    }else{
                        Log::channel('vehiculosfiles')->info("No existe el vehiculo con id: ".$id[1]);
                    }
                } elseif (is_file($path . DIRECTORY_SEPARATOR . $current)) {
                    //Log::info($ide);
                    //valida que el archivo tenga v1 (factura)
                    if (strpos($current, 'v1') !== false || strpos($current, 'V1') !== false) {
                        //Log::info($path. DIRECTORY_SEPARATOR .$current);
                        $extension = pathinfo($path. DIRECTORY_SEPARATOR .$current);
                        //Log::info("La factura es: ".$extension['extension']);
                        //ALTA EN TABLA DOCS FACTURA
                        $docsFact = new Docs();
                        $docsFact->fk_vehicle = $ide;
                        $docsFact->document_module = 'FACTURA';
                        $doc_file = new UploadedFile($path. DIRECTORY_SEPARATOR.$current, $current, $extension['extension'] = "pdf" ? 'application/pdf': 'text/xml', null, false);
                        $docsFact->name_file = $current;
                        $docsFact->created_at = Carbon::now();
                        //$filePath =  env('FOLDER_DIRECTIVE_AWS').'/Activos/vehiculos/'.$ide.'/Factura/'.date("Y").'/Enero';
                        $filePath =  'TMS/Activos/vehiculos/'.$ide.'/Factura/'.date("Y").'/Enero';
                        //Valida si este archivo ya fue cargado con anterioridad
                        if(Storage::disk('s3')->exists($filePath."/".$current)){
                            Log::channel('vehiculosfiles')->info("Factura existente");
                            $url_s3_factura = Storage::disk('s3')->path($filePath."/".$current);
                        }else{
                            Log::channel('vehiculosfiles')->info("Factura nueva");
                            $url_s3_factura = Storage::disk('s3')->putFileAs($filePath, $doc_file, $current, 'public');   
                        }
                        //Log::info("La url del vehiculo ".$item->pk_vehicle." es: ".$url_s3_factura);
                        $docsFact->url_file = $url_s3_factura;
                        $docsFact->save();
                        //ALTA EN TABLA DOCS FACTURA                        
                    }
                    //valida que el archivo tenga v2 (tarjeta)
                    else if(strpos($current, 'v2') !== false || strpos($current, 'V2') !== false){
                        //Log::info($path. DIRECTORY_SEPARATOR .$current);
                        $extension = pathinfo($path. DIRECTORY_SEPARATOR .$current);
                        //Log::info("La tarjeta es: ".$extension['extension']);
                        //ALTA EN TABLA DOCS TARJETAS DE CIRCULACION
                        $docsTarjeta = new Docs();
                        $docsTarjeta->fk_vehicle = $ide;
                        $docsTarjeta->document_module = 'TARJETA DE CIRULACIÓN';
                        $doc_file = new UploadedFile($path. DIRECTORY_SEPARATOR .$current, $current, 'application/pdf', null, false);
                        $docsTarjeta->name_file = $current;
                        $docsTarjeta->created_at = Carbon::now();
                        //$filePath =  env('FOLDER_DIRECTIVE_AWS').'/Activos/vehiculos/'.$ide.'/TarjetasCirculacion/'.date("Y").'/Enero';
                        $filePath =  'TMS/Activos/vehiculos/'.$ide.'/TarjetasCirculacion/'.date("Y").'/Enero';
                        //Valida si este archivo ya fue cargado con anterioridad
                        if(Storage::disk('s3')->exists($filePath."/".$current)){
                            Log::channel('vehiculosfiles')->info("Tarjeta existente");
                            $url_s3_tarjeta = Storage::disk('s3')->path($filePath."/".$current);
                        }else{
                            Log::channel('vehiculosfiles')->info("Tarjeta nuevq");
                            $url_s3_tarjeta = Storage::disk('s3')->putFileAs($filePath, $doc_file, $current, 'public');   
                        }
                        //Log::info("La url del vehiculo ".$ide." es: ".$url_s3_tarjeta);
                        $docsTarjeta->url_file = $url_s3_tarjeta;
                            
                            //ALTA EN TABLA HISTORICO TARJETAS CIRCULACION
                            DB::table('historico_tarjetas_circulacion')->insert([
                                'fk_vehicle' => $ide,
                                'fk_user' => /* Auth::user()->id */ 1,
                                'url_file' => $url_s3_tarjeta,
                                'fecha_transaccion' => $this->timestampUnique,
                            ]);
                            //ALTA EN TABLA HISTORICO TARJETAS CIRCULACION

                        $docsTarjeta->save();
                        //ALTA EN TABLA DOCS TARJETA DE CIRULACION

                    }
                 
                    //$archivos[] = $folder = str_replace("\\", "/",$path . DIRECTORY_SEPARATOR . $current);
                }
            }
        }
    }

    public function findInJsonInfo($date){
        try {
            array_filter( json_decode(File::get(base_path() . '/database/json/vehicles_info.json')), function( $e ) use($date) {
                return $e['IdVehiculo'] == $date;
            });
        } catch (\Throwable $th) {
            return null;
        }   
    }
}
