<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ZipcodesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $zipcodes = fopen(base_path(). '/database/csv/tms_am_zipcodes.csv', 'r');
        while( ($line = fgetcsv($zipcodes, 1000, ',')) !== FALSE ) {
            DB::table('tms_am_zipcodes')->insert([
                'pk_zipcode' => $line[0],
                'zipcode' => $line[1],
                'suburb' => $line[2],
                'suburb_type' => $line[3],
                'country' => $line[4],
                'country_state' => $line[5],
                'city' => $line[6]
            ]);
         } 
         fclose($zipcodes);
    }
}
