
<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;

//Route::middleware('auth:api')->group(function () {//passport

/********************************************************
    Api para TMS ACTIVOS
********************************************************/
Route::apiResource('/tms_mov_activos/colores', 'API\ColorsController');
Route::apiResource('/tms_mov_activos/gasolina', 'API\GasolinaController');
Route::apiResource('/tms_mov_activos/marcas', 'API\MarcasController');
Route::apiResource('/tms_mov_activos/status_vehiculo', 'API\VehiculosEstatusController');
Route::apiResource('/tms_mov_activos/gps_proveedores', 'API\GpsProvidersController');
Route::apiResource('/tms_mov_activos/status_vehiculo_grupo', 'API\VehiculosEstatusGrupoController');
Route::apiResource('/tms_mov_activos/tipo_vehiculo', 'API\VehiculosTipoController');
Route::apiResource('/tms_mov_activos/uso_vehiculo', 'API\VehiculosUsagesController');
Route::apiResource('/tms_mov_activos/modelo_vehiculo', 'API\VehiculosModeloController');
Route::apiResource('/tms_mov_activos/origen_vehiculo', 'API\VehiculosOrigenController');
Route::apiResource('/tms_mov_activos/flota_vehiculo', 'API\VehiculosFlotaController');
Route::apiResource('/tms_mov_activos/catalogo_vehiculo', 'API\VehiculosCatalogoController');
Route::post('/tms_mov_activos/catalogo_vehiculo/resultadosparecidos', 'API\VehiculosCatalogoController@findResults');
Route::apiResource('/tms_mov_activos/tipo_asiento', 'API\TiposAsientoController');
Route::apiResource('/tms_mov_activos/tipo_suspension', 'API\TiposSupensionController');
Route::apiResource('/tms_mov_activos/estacionamientos', 'API\EstacionamientosController');
Route::get('/tms_mov_activos/entidad', 'API\EntidadController@index');
Route::get('/tms_mov_activos/entidad_federativa', 'API\EntidadFederativaController@index');
Route::apiResource('/tms_mov_activos/vehiculo', 'API\VehiculoController');
Route::post('/tms_mov_activos/contratos_seguro', 'API\ContratoAseguradorasController@store');
Route::patch('/tms_mov_activos/contratos_seguro/{id}', 'API\ContratoAseguradorasController@update');
Route::get('/tms_mov_activos/aseguradora', 'API\AseguradorasController@index');
Route::get('/tms_mov_activos/complemento', 'API\ComplementoController@index');
Route::patch('/tms_mov_activos/complemento/{id}', 'API\ComplementoController@update');
Route::apiResource('/tms_mov_activos/adquisiciones', 'API\AdquisicionController');
Route::get('/tms_mov_activos/adquisiciones/findVehicle/{id}', 'API\AdquisicionController@findByVehicle');

Route::get('/tms_mov_activos/validate_cp/{zipcode}', 'API\ZipcodeController@validatecp');
Route::post('/tms_mov_activos/imagenes', 'API\ImagenesController@storeImages');
Route::post('/tms_mov_activos/imagenesActuales', 'API\ImagenesController@storeImagesActually');

Route::apiResource('/tms_mov_activos/menus', 'API\MenuController');
Route::apiResource('/tms_mov_activos/roles', 'API\RolesController');

Route::get('/tms_mov_activos/getMenusByRole/{id}', 'API\MenuRoleController@menusByRole');
Route::post('/tms_mov_activos/syncMenusRoles', 'API\MenuRoleController@syncData');
Route::get('tms_mov_activos/menusAsigandos/{id_rol}', 'API\MenuRoleController@listMenusByRol');

Route::post('/tms_mov_activos/generarZip', 'API\ZipFileController@download');
Route::get('/tms_mov_activos/cascadeoIn/{id}', 'API\CascadeoController@getHistoryVehicle');
Route::post('/tms_mov_activos/generarExcel', 'API\ExcelController@downloadFile');
Route::get('/tms_mov_activos/reporteVehicular', 'API\ExcelController@reporteVehicular');
//});

/********************************************************
    Api para terceros
********************************************************/
//vehiculos por unidad de negocio
Route::get('/tms_mov_activos/external/vehicles/{entity_company}', 'API\VehiculoController@showVehiclesByEntity');
//Vehiculos por unidad de negocio y marca
Route::get('/tms_mov_activos/external/vehicles/{entity_company}/manufacturer/{manufacturer}', 'API\VehiculoController@showVehiclesByEntityAndManufacturer');
//vehiculos por unidad de negocio y vehiculo en especfico
Route::get('/tms_mov_activos/external/vehicles/{entity_company}/findBy/{id_vehicle}', 'API\VehiculoController@showVehiclesByEntityAndId');
//vehiculos por unidad de negocio a traves de la descripcion
Route::get('/tms_mov_activos/external/vehicles/{entity_company}/description/{description}', 'API\VehiculoController@showVehiclesByEntityAndDescription');
//Retornar capacidad del tanque del vehiculo
//2025-09-21 se modifica para poder conetar con el sistema de Odoo
Route::get('/tms_mov_activos/external/vehicleCapacityFuelCurrent', 'API\VehiculoController@showCapacityFuelCurrentByVehicle');
Route::get('/tms_mov_activos/external/vehicleCapacityFuelCurrentDev', 'API\VehiculoController@showCapacityFuelCurrentByVehicleDev');

//Actualiza capacidad del tanque del vehiculo
Route::post('/tms_mov_activos/external/updateVehicleCapacityFuelCurrent', 'API\VehiculoController@updateCapacityFuelCurrentByVehicle');

//Vehiculos con tanque modififcado
//2025-09-21 Adrian Ortiz indica que no se usa en el el sistema de combustibles pero se deja para no afectar las llamadas
Route::get('/tms_mov_activos/external/selectVehicleCapacityFuelCurrent', 'API\VehiculoController@selectVehiclesWithFuelModified');
Route::get('/tms_mov_activos/external/selectVehicleCapacityFuelCurrentDev', 'API\VehiculoController@selectVehiclesWithFuelModifiedDev');
Route::get('/tms_mov_activos/external/selectVehicleCapacityFuelCurrentOdoo', 'API\VehiculoController@selectVehiclesWithFuelModifiedOdoo');



Route::get('/tms_mov_activos/ubicacion-vehiculos-traffilog', 'API\VehiculoController@getVehiclesTraffilog');